unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TMainForm = class(TForm)
    cb1: TComboBox;
    cb2: TComboBox;
    cb3: TComboBox;
    cb4: TComboBox;
    cb5: TComboBox;
    Image1: TImage;
    Panel1: TPanel;
    imgKONIEC: TImage;
    procedure FormCreate(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);

  private

  public
    procedure Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}

procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_YESNO or MB_ICONEXCLAMATION) = IDYES then
   begin
      Application.Terminate();
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
	txt : String;
   fn  : String;
   bmp : TBitmap;

begin
	cb1.Clear();
   cb2.Clear();
   cb3.Clear();
   cb4.Clear();
   cb5.Clear();

	txt := '';
	fn  := '';
   
   fn := ExtractFilePath(Application.ExeName) + 'woj.txt';
   if FileExists(fn) then
   begin
   	cb1.Items.LoadFromFile(fn);
   	cb2.Items.LoadFromFile(fn);
   	cb3.Items.LoadFromFile(fn);
   	cb4.Items.LoadFromFile(fn);
   end;

	cb5.Items.Add('Jeden');
	cb5.Items.Add('Dwa');
	cb5.Items.Add('Trzy');

	cb1.ItemIndex := 0;
   cb2.ItemIndex := 1;
   cb3.ItemIndex := 2;
   cb4.ItemIndex := 3;
   cb5.ItemIndex := 0;
   
   // odajemy obiekt w postaci bitmapy
   bmp := TBitmap.Create();
   bmp.LoadFromFile('arrow1l.bmp');
	// na pozycji 3
   cb5.Items.AddObject('Nazwa wasna', bmp);
   txt := cb5.Items.Strings[3];
   // ShowMessage(txt);
   Image1.Picture.Bitmap.Assign(TBitmap(cb5.Items.Objects[3]));

   FreeAndNil(bmp);
end;

end.
